# <copyright>
# INTEL CONFIDENTIAL
#
# Copyright 2021 Intel Corporation
#
# This software and the related documents are Intel copyrighted materials, and your use of
# them is governed by the express license under which they were provided to you ("License").
# Unless the License provides otherwise, you may not use, modify, copy, publish, distribute,
# disclose or transmit this software or the related documents without Intel's prior written
# permission.
#
# This software and the related documents are provided as is, with no express or implied
# warranties, other than those that are expressly stated in the License.
#
# <copyright>

# Suppress irrelevant PS Script Analyzer warnings
[Diagnostics.CodeAnalysis.SuppressMessageAttribute("PSUseDeclaredVarsMoreThanAssignments", "")] Param()

$BusTypeMap = [ordered]@{
    0 = $Messages.Unknown
    1 = $Messages.ISA
    2 = $Messages.EISA
    3 = $Messages.PCMCIA
    4 = $Messages.CardBus
    5 = $Messages.PCI
    6 = $Messages.PCIX
    7 = $Messages.PCIExpress
    8 = $Messages.IOSF
}

# Map from *SpeedDuplex enum values to possible adapter speeds
$SupportedSpeedsMap = [ordered]@{
    "0"      = 0            #AutoNegotiation
    "1"      = 10000000     #10Mb Half Duplex
    "2"      = 10000000     #10Mb Full Duplex
    "3"      = 100000000    #100Mb Half Duplex
    "4"      = 100000000    #100Mb Full Duplex
    "5"      = 1000000000   #1Gb Full Duplex NDIS5
    "6"      = 1000000000   #1Gb Full Duplex NDIS6
    "7"      = 10000000000  #10Gb Full Duplex
    "8"      = 10000000000  #10Gb Half Duplex
    "9"      = 40000000000  #40Gb Half Duplex
    "2500"   = 2500000000   #2.5Gb
    "5000"   = 5000000000   #5Gb
    "25000"  = 25000000000  #25Gb
    "500000" = 50000000000  #50Gb
    "10"     = 100000000000 #100Gb
}


enum ADAPTER_STATUS
{
    Installed    = 0x1
    DriverLoaded = 0x2
    HwMissing    = 0x4
    Reserved     = 0x8
    HasDiag      = 0x10
    HasLink      = 0x20
    PoweredOff   = 0x1000
}


enum CVL_PHY_TYPE
{
    CVL100BaseTX = 0x0
    CVL100MSGMII = 0x1
    CVL1000BaseT = 0x2
    CVL1000BaseSX = 0x3
    CVL1000BaseLX = 0x4
    CVL1000BaseKX = 0x5
    CVL1GSGMII = 0x6
    CVL2Point5GBaseT = 0x7
    CVL2Point5gBaseX = 0x8
    CVL2Point5GBaseKX = 0x9
    CVL5GBaseT = 0xA
    CVL5GBaseKR = 0xB
    CVL10GBaseT = 0xC
    CVL10GSFIDA = 0xD
    CVL10GBaseSR = 0xE
    CVL10GBaseLR = 0xF
    CVL10GBaseKR = 0x10
    CVL10GSFIAOC_ACC = 0x11
    CVL10GSFIC2C = 0x12
    CVL25GBaseT = 0x13
    CVL25GBaseCR = 0x14
    CVL25GBaseCRS = 0x15
    CVL25GBaseCR1 = 0x16
    CVL25GBaseSR = 0x17
    CVL25GBaseLR = 0x18
    CVL25GBaseKR = 0x19
    CVL25GBaseKRS = 0x1A
    CVL25GBaseKR1 = 0x1B
    CVL25GAUIAOC_ACC = 0x1C
    CVL25GAUIC2C = 0x1D
    CVL40GBaseCR4 = 0x1E
    CVL40GBaseSR4 = 0x1F
    CVL40GBaseLR4 = 0x20
    CVL40GBaseKR4 = 0x21
    CVL40GXLAUIAOC_ACC = 0x22
    CVL40GXLAUI = 0x23
    CVL50GBaseCR2 = 0x24
    CVL50GBaseKR2 = 0x27
    CVL50GLAUI2AOC_ACC = 0x28
    CVL50GLAUI2 = 0x29
    CVL50GAUI2AOC_ACC = 0x2A
    CVL50GAUI2 = 0x2B
    CVL50GBaseCRPAM4 = 0x2C
    CVL50GBaseSR = 0x2D
    CVL50GBaseFR = 0x2E
    CVL50GBaseLR = 0x2F
    CVL50GBaseKRPAM4 = 0x30
    CVL50GAUI1AOC_ACC = 0x31
    CVL50GAUI1 = 0x32
    CVL100GBaseCR4 = 0x33
    CVL100GBaseSR4 = 0x34
    CVL100GBaseLR4 = 0x35
    CVL100GBaseKR4 = 0x36
    CVL100GCAUI4AOC_ACC = 0x37
    CVL100GCAUI4 = 0x38
    CVL100GAUI4AOC_ACC = 0x39
    CVL100GAUI4 = 0x3A
    CVL100GBaseKR4PAM4 = 0x3C
    CVL100GBaseCP2 = 0x3D
    CVL100GBaseSR2 = 0x3E
    CVL100GBaseDR = 0x3F
    CVL100GBaseKR2PAM4 = 0x40
    CVL100GAUI2AOC_ACC = 0x43
    CVL100GAUI2 = 0x44
    CVL200GBaseCR4PAM4 = 0x45
    CVL200GBaseSR4 = 0x46
    CVL200GBaseFR4 = 0x47
    CVL200GBaseLR4 = 0x48
    CVL200GBaseDR4 = 0x49
    CVL200GBaseKR4PAM4 = 0x4A
    CVL200GAUI4AOC_ACC = 0x4B
    CVL200GAUI4 = 0x4C
    CVL200GAUI8AOC_ACC = 0x4D
    CVL200GAUI8 = 0x4E
    CVL400GBaseFR8 = 0x4F
    CVL400GBaseLR8 = 0x50
    CVL400GBaseDR4 = 0x51
    CVL400GAUI8AOC_ACC = 0x52
    CVL400GAUI8 = 0x53
    CVLAutoNegotiation = 0x7E
    CVLOuterphydisabled = 0x7F
}

enum CPK_PHY_INFO
{
    CPK_PHYINFO_MEDIA_BACKPLANE = 1
    CPK_PHYINFO_MEDIA_QSFP      = 2
    CPK_PHYINFO_MEDIA_SFP       = 3
    CPK_PHYINFO_MEDIA_BASE_T    = 4
    CPK_PHYINFO_MEDIA_SGMII     = 5
    CPK_PHYINFO_MEDIA_FIBER     = 6
}

enum NCS_ADAPTER_MEDIA_TYPE
{
    NCS_MEDIA_UNKNOWN = 0
    NCS_MEDIA_COPPER = 1
    NCS_MEDIA_FIBER = 2
    NCS_MEDIA_PHONELINE = 3
    NCS_MEDIA_CX4COPPER = 4
    NCS_MEDIA_SFPDIRECTATTACH = 5
    NCS_MEDIA_SR_FIBER = 6
    NCS_MEDIA_LR_FIBER = 7
    NCS_MEDIA_KX4BACKPLANE = 8
    NCS_MEDIA_SERDES = 9
    NCS_MEDIA_BACKPLANE = 10
    NCS_MEDIA_XAUI = 11
    NCS_MEDIA_SFPACTIVEDIRECTATTACH = 12
    NCS_MEDIA_SWITCHHOST = 13
    NCS_MEDIA_QSFPDIRECTATTACH = 14
    NCS_MEDIA_SFP28DIRECTATTACH = 15
    NCS_MEDIA_CVL_AOC_ACC = 16
    NCS_MEDIA_CVL_Backplane_KR = 17
    NCS_MEDIA_CVL_Backplane_KR1 = 18
    NCS_MEDIA_CVL_Backplane_KR2 = 19
    NCS_MEDIA_CVL_Backplane_KR2_PAM4 = 20
    NCS_MEDIA_CVL_Backplane_KR4 = 21
    NCS_MEDIA_CVL_Backplane_KR4_PAM4 = 22
    NCS_MEDIA_CVL_Backplane_KR_PAM4 = 23
    NCS_MEDIA_CVL_Backplane_KR_S = 24
    NCS_MEDIA_CVL_Backplane_KX = 25
    NCS_MEDIA_CVL_Chip_to_Chip = 26
    NCS_MEDIA_CVL_Copper_T = 27
    NCS_MEDIA_CVL_Copper_TX = 28
    NCS_MEDIA_CVL_Direct_Attach = 29
    NCS_MEDIA_CVL_Direct_Attach_CP2 = 30
    NCS_MEDIA_CVL_Direct_Attach_CR = 31
    NCS_MEDIA_CVL_Direct_Attach_CR1 = 32
    NCS_MEDIA_CVL_Direct_Attach_CR2 = 33
    NCS_MEDIA_CVL_Direct_Attach_CR4 = 34
    NCS_MEDIA_CVL_Direct_Attach_CR_PAM4 = 35
    NCS_MEDIA_CVL_Direct_Attach_CR_S = 36
    NCS_MEDIA_CVL_Fiber_DR = 37
    NCS_MEDIA_CVL_Fiber_FR = 38
    NCS_MEDIA_CVL_Fiber_LR = 39
    NCS_MEDIA_CVL_Fiber_LR4 = 40
    NCS_MEDIA_CVL_Fiber_LX = 41
    NCS_MEDIA_CVL_Fiber_SR = 42
    NCS_MEDIA_CVL_Fiber_SR2 = 43
    NCS_MEDIA_CVL_Fiber_SR4 = 44
    NCS_MEDIA_CVL_Fiber_SX = 45
    NCS_MEDIA_CVL_Fiber_X = 46
    NCS_MEDIA_CVL_SGMII = 47
    NCS_MEDIA_CVL_Unknown = 48
    NCS_MEDIA_INTERFACE_CVL_BACKPLANE = 1000
    NCS_MEDIA_INTERFACE_CVL_QSFP = 1001
    NCS_MEDIA_INTERFACE_CVL_SFP = 1002
    NCS_MEDIA_INTERFACE_CVL_BASE_T = 1003
    NCS_MEDIA_INTERFACE_CVL_SGMII = 1004
    NCS_MEDIA_INTERFACE_CVL_FIBER = 1005
}

enum I40E_PHY_TYPE
{
    I40E_PHY_TYPE_SGMII                     = 0x0
    I40E_PHY_TYPE_1000BASE_KX               = 0x1
    I40E_PHY_TYPE_10GBASE_KX4               = 0x2
    I40E_PHY_TYPE_10GBASE_KR                = 0x3
    I40E_PHY_TYPE_40GBASE_KR4               = 0x4
    I40E_PHY_TYPE_XAUI                      = 0x5
    I40E_PHY_TYPE_XFI                       = 0x6
    I40E_PHY_TYPE_SFI                       = 0x7
    I40E_PHY_TYPE_XLAUI                     = 0x8
    I40E_PHY_TYPE_XLPPI                     = 0x9
    I40E_PHY_TYPE_40GBASE_CR4_CU            = 0xA
    I40E_PHY_TYPE_10GBASE_CR1_CU            = 0xB
    I40E_PHY_TYPE_10GBASE_AOC               = 0xC
    I40E_PHY_TYPE_40GBASE_AOC               = 0xD
    I40E_PHY_TYPE_UNRECOGNIZED              = 0xE
    I40E_PHY_TYPE_UNSUPPORTED               = 0xF
    I40E_PHY_TYPE_100BASE_TX                = 0x11
    I40E_PHY_TYPE_1000BASE_T                = 0x12
    I40E_PHY_TYPE_10GBASE_T                 = 0x13
    I40E_PHY_TYPE_10GBASE_SR                = 0x14
    I40E_PHY_TYPE_10GBASE_LR                = 0x15
    I40E_PHY_TYPE_10GBASE_SFPP_CU           = 0x16
    I40E_PHY_TYPE_10GBASE_CR1               = 0x17
    I40E_PHY_TYPE_40GBASE_CR4               = 0x18
    I40E_PHY_TYPE_40GBASE_SR4               = 0x19
    I40E_PHY_TYPE_40GBASE_LR4               = 0x1A
    I40E_PHY_TYPE_1000BASE_SX               = 0x1B
    I40E_PHY_TYPE_1000BASE_LX               = 0x1C
    I40E_PHY_TYPE_1000BASE_T_OPTICAL        = 0x1D
    I40E_PHY_TYPE_20GBASE_KR2               = 0x1E
    I40E_PHY_TYPE_25GBASE_KR                = 0x1F
    I40E_PHY_TYPE_25GBASE_CR                = 0x20
    I40E_PHY_TYPE_25GBASE_SR                = 0x21
    I40E_PHY_TYPE_25GBASE_LR                = 0x22
    I40E_PHY_TYPE_25GBASE_AOC               = 0x23
    I40E_PHY_TYPE_25GBASE_ACC               = 0x24
    I40E_PHY_TYPE_2_5GBASE_T                = 0x26
    I40E_PHY_TYPE_5GBASE_T                  = 0x27
    I40E_PHY_TYPE_2_5GBASE_T_LINK_STATUS    = 0x30
    I40E_PHY_TYPE_5GBASE_T_LINK_STATUS      = 0x31
    I40E_PHY_TYPE_NOT_SUPPORTED_HIGH_TEMP   = 0xFD
    I40E_PHY_TYPE_EMPTY                     = 0xFE
    I40E_PHY_TYPE_DEFAULT                   = 0xFF
}

enum LinkType
{
    LINK_TYPE_SGMII              = 0x1
    LINK_TYPE_1000BASE_KX        = 0x2
    LINK_TYPE_10GBASE_KX4        = 0x4
    LINK_TYPE_10GBASE_KR         = 0x8
    LINK_TYPE_40GBASE_KR4        = 0x10
    LINK_TYPE_XAUI               = 0x20
    LINK_TYPE_XFI                = 0x40
    LINK_TYPE_SFI                = 0x80
    LINK_TYPE_XLAUI              = 0x100
    LINK_TYPE_XLPPI              = 0x200
    LINK_TYPE_40GBASE_CR4_CU     = 0x400
    LINK_TYPE_10GBASE_CR1_CU     = 0x800
    LINK_TYPE_100BASE_TX         = 0x20000
    LINK_TYPE_1000BASE_T         = 0x40000
    LINK_TYPE_10GBASE_T          = 0x80000
    LINK_TYPE_10GBASE_SR         = 0x100000
    LINK_TYPE_10GBASE_LR         = 0x200000
    LINK_TYPE_10GBASE_SFP_Cu     = 0x400000
    LINK_TYPE_10GBASE_CR1        = 0x800000
    LINK_TYPE_40GBASE_CR4        = 0x1000000
    LINK_TYPE_40GBASE_SR4        = 0x2000000
    LINK_TYPE_40GBASE_LR4        = 0x4000000
    LINK_TYPE_1000BASE_SX        = 0x8000000
    LINK_TYPE_1000BASE_LX        = 0x10000000
    LINK_TYPE_1000BASE_T_Optical = 0x20000000
    LINK_TYPE_20GBASE_KR2        = 0x40000000
}

enum LinkTypeExt
{
    LINK_TYPE_25GBase_KR         = 0x1
    LINK_TYPE_25GBase_CR         = 0x2
    LINK_TYPE_25GBase_SR         = 0x4
    LINK_TYPE_25GBase_LR         = 0x8
    LINK_TYPE_25G_AOC            = 0x10
    LINK_TYPE_25G_ACC            = 0x20
    LINK_TYPE_2_5GBASE_T         = 0x40
    LINK_TYPE_5GBASE_T           = 0x80
}

enum ADAPTER_CAPABILITY
{
    NCS_ADAPTER_CAP_UNKNOWN = 0
    NCS_ADAPTER_CAP_OTHER = 1
    NCS_ADAPTER_CAP_WAKE_ON_LAN = 3
    NCS_ADAPTER_CAP_FAILOVER = 4
    NCS_ADAPTER_CAP_LOADBALANCING = 5
    NCS_ADAPTER_CAP_IPSEC_OFFLOAD = 6
    NCS_ADAPTER_CAP_FEC = 9
    NCS_ADAPTER_CAP_802_3AD = 10
    NCS_ADAPTER_CAP_CHECKSUM_OFFLOAD = 11
    NCS_ADAPTER_CAP_SWITCHED_FAULT_TOLERANT = 12
    NCS_ADAPTER_CAP_TCO_CAPABILITY = 29
    NCS_ADAPTER_CAP_WAKEUP_CAPABILITIES = 30
    NCS_ADAPTER_CAP_IP_CHECKSUM_OFFLOAD = 31
    NCS_ADAPTER_CAP_SPEED_10_MBPS = 32
    NCS_ADAPTER_CAP_SPEED_100_MBPS = 33
    NCS_ADAPTER_CAP_SPEED_1000_MBPS = 34
    NCS_ADAPTER_CAP_SPEED_10000_MBPS = 35
    NCS_ADAPTER_CAP_TEAM_SUPPORT = 36
    NCS_ADAPTER_CAP_VLAN_SUPPORT = 37
    NCS_ADAPTER_CAP_VLAN_TYPE_IEEE = 38
    NCS_ADAPTER_CAP_VLAN_TYPE_ISL = 39
    NCS_ADAPTER_CAP_IDENTIFY_ADAPTER_SUPPORT = 41
    NCS_ADAPTER_CAP_CABLE_TEST_SUPPORT = 42
    NCS_ADAPTER_CAP_DIAGNOSTIC_SUPPORT = 43
    NCS_ADAPTER_CAP_FLASH_SUPPORT = 44
    NCS_ADAPTER_CAP_USAGE_SERVER = 46
    NCS_ADAPTER_CAP_VENDOR_INTEL = 47
    NCS_ADAPTER_CAP_PWMGMT_SUPPORT = 50
    NCS_ADAPTER_CAP_QUAD_PORT = 54
    NCS_ADAPTER_CAP_JUMBO_FRAMES = 56
    NCS_ADAPTER_CAP_IGP_SIGNAL_QUALITY_TEST = 58
    NCS_ADAPTER_CAP_CABLE_OFFLINE_TEST = 59
    NCS_ADAPTER_IS_A_LOM = 60
    NCS_ADAPTER_CAP_NDIS_IOAT = 61
    NCS_ADAPTER_CAP_CB_PLATFORM_IOAT = 62
    NCS_ADAPTER_CAP_ISCSI = 63
    NCS_ADAPTER_CAP_DCB = 65
    NCS_ADAPTER_CAP_FCOE = 66
    NCS_ADAPTER_CAP_KX_MODULE   = 67
    NCS_ADAPTER_CAP_VM_LOADBALANCING = 68
    NCS_ADAPTER_CAP_PERFORMANCE_PROFILE = 69
    NCS_ADAPTER_CAP_OS2BMC = 70
    NCS_ADAPTER_CAP_AMT = 71
    NCS_ADAPTER_CAP_SPEED_2500_MBPS = 72
    NCS_ADAPTER_CAP_BASIC_DMIX_SUPPORT = 73
    NCS_ADAPTER_CAP_EXTENDED_DMIX_SUPPORT = 74
    NCS_ADAPTER_CAP_SPEED_40000_MBPS = 75
    NCS_ADAPTER_CAP_NPAR_ENABLED = 76
    NCS_ADAPTER_CAP_ANS_SUPPORTED = 77
    NCS_ADAPTER_CAP_QSFP_LINK_MODE_ENABLED = 78
    NCS_ADAPTER_CAP_SPEED_25000_MBPS = 79
    NCS_ADAPTER_CAP_NPAR_CAPABLE = 80
    NCS_ADAPTER_CAP_SPEED_5000_MBPS = 81
    NCS_ADAPTER_CAP_SPEED_50000_MBPS = 82
    NCS_ADAPTER_CAP_SPEED_100000_MBPS = 83
    NCS_ADAPTER_CAP_CYPRESS = 84
}

# from MSFT_NetAdapterAdvancedPropertySettingData WMI class
enum DisplayParameterType
{
    int   = 1
    long  = 2
    word  = 3
    dword = 4
    enum  = 5
    edit  = 6
}

# from MSFT_NetAdapter WMI class
enum NetAdapterState
{
    Unknown  = 0
    Present  = 1
    Started  = 2
    Disabled = 3
}

$NETWORK_ADDRESS_LEN = 12


# SIG # Begin signature block
# MIIotwYJKoZIhvcNAQcCoIIoqDCCKKQCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCDKbtkORmWKugoD
# fuu4I+mY//4Ag7b8IIUAwKYyxp+QnqCCEgUwggWeMIIEhqADAgECAhEAzS1l4rws
# CIvYBjRVawV4ujANBgkqhkiG9w0BAQsFADB8MQswCQYDVQQGEwJHQjEbMBkGA1UE
# CBMSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYDVQQK
# Ew9TZWN0aWdvIExpbWl0ZWQxJDAiBgNVBAMTG1NlY3RpZ28gUlNBIENvZGUgU2ln
# bmluZyBDQTAeFw0yMTA0MDIwMDAwMDBaFw0yMzA0MDIyMzU5NTlaMIGEMQswCQYD
# VQQGEwJVUzETMBEGA1UECAwKQ2FsaWZvcm5pYTEUMBIGA1UEBwwLU2FudGEgQ2xh
# cmExGjAYBgNVBAoMEUludGVsIENvcnBvcmF0aW9uMRIwEAYDVQQLDAlTb2xhcktN
# Q1MxGjAYBgNVBAMMEUludGVsIENvcnBvcmF0aW9uMIIBojANBgkqhkiG9w0BAQEF
# AAOCAY8AMIIBigKCAYEA7CCN9iKpDHOrRceKhlXFP/tf6Lllw2H2fR9KVI4/fQIx
# MU1hXwnlHmAzMCY7IgcCFY4p3F5/MJGKaqYngwOo28Zo6Q1N6ukysA7PSavmF2RY
# WD6VFeya/2H0PoNeRFjHaRzSeynFFeJAFew9r7UReUwM/507sxZYPQuWWIdAEK7H
# Dqp2VlHmgZOXVGHhNO6GFOKpC/C01g6X3x6OquddRNMt5UrZzZzDo5MpJz9SBB2V
# jiqwZ80dvNR2W2xi90cIHh4BkXvB54UNkp4VTVu16T0k3cweo+C39U7GrCAr5Axz
# DETjBvhNtP1sf9SoRV7xY6g5wssfI7yYT9J0gsifn/Vy8MWH355TPoA+PVhbAu0m
# 9FMz4EWu55nnUurNML2jaUxsos21/7ELat12kWC0tq9fhkODjKO8X9PuiBHflZLk
# d3F4QcSMvuGocWGqE77VV3vn8jlvigm2TOV0CfGTQajGMX0jeTRZ19fzBNkt2X9d
# SSGolI/Kj1gSvCggpkUBAgMBAAGjggGQMIIBjDAfBgNVHSMEGDAWgBQO4TqoUzox
# 1Yq+wbutZxoDha00DjAdBgNVHQ4EFgQUshkNuM2SdwJnW4vFy8c4FtUTrbQwDgYD
# VR0PAQH/BAQDAgeAMAwGA1UdEwEB/wQCMAAwEwYDVR0lBAwwCgYIKwYBBQUHAwMw
# EQYJYIZIAYb4QgEBBAQDAgQQMEoGA1UdIARDMEEwNQYMKwYBBAGyMQECAQMCMCUw
# IwYIKwYBBQUHAgEWF2h0dHBzOi8vc2VjdGlnby5jb20vQ1BTMAgGBmeBDAEEATBD
# BgNVHR8EPDA6MDigNqA0hjJodHRwOi8vY3JsLnNlY3RpZ28uY29tL1NlY3RpZ29S
# U0FDb2RlU2lnbmluZ0NBLmNybDBzBggrBgEFBQcBAQRnMGUwPgYIKwYBBQUHMAKG
# Mmh0dHA6Ly9jcnQuc2VjdGlnby5jb20vU2VjdGlnb1JTQUNvZGVTaWduaW5nQ0Eu
# Y3J0MCMGCCsGAQUFBzABhhdodHRwOi8vb2NzcC5zZWN0aWdvLmNvbTANBgkqhkiG
# 9w0BAQsFAAOCAQEAVadLNRW4f/pKMqrbn0BdOoQ8/1EJ87gvVfosei2bLwTEvpmv
# mn2n561H6AFedtIJ6L4FmXII4M4r20i+5LREbI6PpKDmOAf4xW7POxfCRvkTQAZO
# 3zoVxjMQBXo7cZVF1xHCdviXzD1usuIiCF8DLm6z4O/kyeFFNcn816yPQct91Pnk
# SBBVvL+Kwu8xvR+ZIQy632WUA4HnNpRdFnVSzUifEg2GrtsKZR8k+rm2o8K8yjJq
# 3SznwgJQCMVMh3CtRtUwE/c7o/6rvm53fTYJDd3aoPHVgH6S2WqS3+3mQG7A6hTD
# nrP/mYnS4PF7XzxxjZhUlhy4G/MarJPvT9IrNDCCBfUwggPdoAMCAQICEB2iSDBv
# myYY0ILgln0z02owDQYJKoZIhvcNAQEMBQAwgYgxCzAJBgNVBAYTAlVTMRMwEQYD
# VQQIEwpOZXcgSmVyc2V5MRQwEgYDVQQHEwtKZXJzZXkgQ2l0eTEeMBwGA1UEChMV
# VGhlIFVTRVJUUlVTVCBOZXR3b3JrMS4wLAYDVQQDEyVVU0VSVHJ1c3QgUlNBIENl
# cnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTE4MTEwMjAwMDAwMFoXDTMwMTIzMTIz
# NTk1OVowfDELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hlc3Rl
# cjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSQw
# IgYDVQQDExtTZWN0aWdvIFJTQSBDb2RlIFNpZ25pbmcgQ0EwggEiMA0GCSqGSIb3
# DQEBAQUAA4IBDwAwggEKAoIBAQCGIo0yhXoYn0nwli9jCB4t3HyfFM/jJrYlZilA
# hlRGdDFixRDtsocnppnLlTDAVvWkdcapDlBipVGREGrgS2Ku/fD4GKyn/+4uMyD6
# DBmJqGx7rQDDYaHcaWVtH24nlteXUYam9CflfGqLlR5bYNV+1xaSnAAvaPeX7Wpy
# vjg7Y96Pv25MQV0SIAhZ6DnNj9LWzwa0VwW2TqE+V2sfmLzEYtYbC43HZhtKn52B
# xHJAteJf7wtF/6POF6YtVbC3sLxUap28jVZTxvC6eVBJLPcDuf4vZTXyIuosB69G
# 2flGHNyMfHEo8/6nxhTdVZFuihEN3wYklX0Pp6F8OtqGNWHTAgMBAAGjggFkMIIB
# YDAfBgNVHSMEGDAWgBRTeb9aqitKz1SA4dibwJ3ysgNmyzAdBgNVHQ4EFgQUDuE6
# qFM6MdWKvsG7rWcaA4WtNA4wDgYDVR0PAQH/BAQDAgGGMBIGA1UdEwEB/wQIMAYB
# Af8CAQAwHQYDVR0lBBYwFAYIKwYBBQUHAwMGCCsGAQUFBwMIMBEGA1UdIAQKMAgw
# BgYEVR0gADBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8vY3JsLnVzZXJ0cnVzdC5j
# b20vVVNFUlRydXN0UlNBQ2VydGlmaWNhdGlvbkF1dGhvcml0eS5jcmwwdgYIKwYB
# BQUHAQEEajBoMD8GCCsGAQUFBzAChjNodHRwOi8vY3J0LnVzZXJ0cnVzdC5jb20v
# VVNFUlRydXN0UlNBQWRkVHJ1c3RDQS5jcnQwJQYIKwYBBQUHMAGGGWh0dHA6Ly9v
# Y3NwLnVzZXJ0cnVzdC5jb20wDQYJKoZIhvcNAQEMBQADggIBAE1jUO1HNEphpNve
# aiqMm/EAAB4dYns61zLC9rPgY7P7YQCImhttEAcET7646ol4IusPRuzzRl5ARokS
# 9At3WpwqQTr81vTr5/cVlTPDoYMot94v5JT3hTODLUpASL+awk9KsY8k9LOBN9O3
# ZLCmI2pZaFJCX/8E6+F0ZXkI9amT3mtxQJmWunjxucjiwwgWsatjWsgVgG10Xkp1
# fqW4w2y1z99KeYdcx0BNYzX2MNPPtQoOCwR/oEuuu6Ol0IQAkz5TXTSlADVpbL6f
# ICUQDRn7UJBhvjmPeo5N9p8OHv4HURJmgyYZSJXOSsnBf/M6BZv5b9+If8AjntIe
# Q3pFMcGcTanwWbJZGehqjSkEAnd8S0vNcL46slVaeD68u28DECV3FTSK+TbMQ5Lk
# uk/xYpMoJVcp+1EZx6ElQGqEV8aynbG8HArafGd+fS7pKEwYfsR7MUFxmksp7As9
# V1DSyt39ngVR5UR43QHesXWYDVQk/fBO4+L4g71yuss9Ou7wXheSaG3IYfmm8SoK
# C6W59J7umDIFhZ7r+YMp08Ysfb06dy6LN0KgaoLtO0qqlBCk4Q34F8W2WnkzGJLj
# tXX4oemOCiUe5B7xn1qHI/+fpFGe+zmAEc3btcSnqIBv5VPU4OOiwtJbGvoyJi1q
# V3AcPKRYLqPzW0sH3DJZ84enGm1YMIIGZjCCBE6gAwIBAgITMwAAAES3P/zvWs+i
# egAAAAAARDANBgkqhkiG9w0BAQUFADB/MQswCQYDVQQGEwJVUzETMBEGA1UECBMK
# V2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
# IENvcnBvcmF0aW9uMSkwJwYDVQQDEyBNaWNyb3NvZnQgQ29kZSBWZXJpZmljYXRp
# b24gUm9vdDAeFw0xNTA3MjIyMTAzNDlaFw0yNTA3MjIyMTAzNDlaMIGIMQswCQYD
# VQQGEwJVUzETMBEGA1UECBMKTmV3IEplcnNleTEUMBIGA1UEBxMLSmVyc2V5IENp
# dHkxHjAcBgNVBAoTFVRoZSBVU0VSVFJVU1QgTmV0d29yazEuMCwGA1UEAxMlVVNF
# UlRydXN0IFJTQSBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTCCAiIwDQYJKoZIhvcN
# AQEBBQADggIPADCCAgoCggIBAIASZRc2DsPbCLPQrFcNdu3NJ9NMrVCDYeKqIE0J
# LWQJ3M6Jn8w9qez2z8Hc8dOx1ns3KBErR9o5xrw6GbRfpr19naNjQrZ28qk7K5H4
# 4m/Q7BYgkAk+4uh0yRi0kdRiZNt/owbxiBhqkCI8vP4T8IcUe/bkH47U5FHGEWdG
# CFHLhhRUP7wz/n5snP8WnRi9UY41pqdmyHJn2yFmsdSbeAPAUDrozPDcvJ5M/q8F
# ljUfV1q3/875PbcstvZU3cjnEjpNrkyKt1yatLcgPcp/IjSufjtoZgFE5wFORlOb
# M2D3lL5TN5BzQ/Myw1Pv26r+dE5px2uMYJPexMcM3+EyrsyTO1F4lWeL7j1W/gzQ
# aQ8bD/MlJmszbfduR/pzQ+V+DqVmsSl8MoRjVYnEDcGTVDAZE6zTfTen6106bDVc
# 20HXEtqpSQvf2ICKCZNijrVmzyWIzYS4sT+kOQ/ZAp7rEkyVfPNrBaleFoPMuGfi
# 6BOdzFuC00yz7Vv/3uVzrCM7LQC/NVV0CUnYSVgaf5I25lGSDvMmfRxNF7zJ7EMm
# 0L9BX0CpRET0medXh55QH1dUqD79dGMvsVBlCeZYQi5DGky08CVHWfoEHpPUJkZK
# UIGy3r54t/xnFeHJV4QeD2PW6WK61l9VLupcxigIBCU5uA4rqfJMlxwHPw1S9e3v
# L4IPAgMBAAGjgdAwgc0wEwYDVR0lBAwwCgYIKwYBBQUHAwMwEgYDVR0TAQH/BAgw
# BgEB/wIBAjAdBgNVHQ4EFgQUU3m/WqorSs9UgOHYm8Cd8rIDZsswCwYDVR0PBAQD
# AgGGMB8GA1UdIwQYMBaAFGL7CiFbf0NuEdoJVFBr9dKWcfGeMFUGA1UdHwROMEww
# SqBIoEaGRGh0dHA6Ly9jcmwubWljcm9zb2Z0LmNvbS9wa2kvY3JsL3Byb2R1Y3Rz
# L01pY3Jvc29mdENvZGVWZXJpZlJvb3QuY3JsMA0GCSqGSIb3DQEBBQUAA4ICAQBr
# IpM8PTlUcWRrDvLkPDARxSBKS4YPkvH/M3k62eSYpw5AoCKAfmGy4KcZzyaVMSpl
# 1GpPMYbqwMYuxWSMPUhZzQsvdD2UJhMQQtSXmCdePHbSeGkdGmTnBXJ14OtmQEOf
# jwxG/5dgpshnrRAIm2Km6b46itMHTZ9ykyW8BhHgLJA4Pmcc/RnXnpDOPcLg52Gs
# wOUE9R6ZVAyRDQFWcTeuJ9SeQyKlySfNTeVxEjkkpUFWh/+8VRQPJcqJ7seX5dIT
# /z1+GqCPP8gs16Nw0MdgwPzYPlHnl8Y+O+3PeL6KyuPE8qen7Z6uCAKPoFLbch7V
# O8NNn476m3DH+OO/bD+Sm+Q3PuxqjCn5waK/iz4aaWb7HGNPJgHJAsQ+0v/DQ6gb
# /Zn61LylueKTLzsBxdH0Oi9ow+Bkt1qVXkbMB4NpuzwFklZzNXNFmE582BKlt0Lp
# omP2QmAYcNE7bzHAh8fmceHzRhbp9bhys+ltH2ImSaNJi91ox4toVvfe/PqHJLgD
# gReP5fFnah2u03T3jKVdswuOQimWzknEd35mfAEXGmwUJMOwF3cF2BpAt4Zr2OR7
# QKx+305vJPkggIKMM+fl+inYndqLcF0ryR2CTAtny4RBnucGfhGDRC2KGe70f5rd
# eRw3GR6fP4wpug1cEIY3bEjNRV3NcLy80U1d2MW4djGCFggwghYEAgEBMIGRMHwx
# CzAJBgNVBAYTAkdCMRswGQYDVQQIExJHcmVhdGVyIE1hbmNoZXN0ZXIxEDAOBgNV
# BAcTB1NhbGZvcmQxGDAWBgNVBAoTD1NlY3RpZ28gTGltaXRlZDEkMCIGA1UEAxMb
# U2VjdGlnbyBSU0EgQ29kZSBTaWduaW5nIENBAhEAzS1l4rwsCIvYBjRVawV4ujAN
# BglghkgBZQMEAgEFAKBqMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisG
# AQQBgjcCAQsxDjAMBgorBgEEAYI3AgEWMC8GCSqGSIb3DQEJBDEiBCBocO8yAi5w
# UUT5jB6CopfKnW3llh9bP3mhreNBbYZBUDANBgkqhkiG9w0BAQEFAASCAYDEgU8f
# nSBPOrjYgoyRtltRb07MjD9vjoAEhp8yWoTebgglIplZzbaorBoYF4OVbRI2TUfN
# zrdfxA9H3MCJqhrye6j+pvCx3wFoGnPPZ9uVS/ZTyn/vzdbKe8dmsTke9xIvlHEQ
# u0tx7rgaoebmae8Oad0Ypm4iTFiK8WvauraNR3mlk1EJdnTNwjpDcEOd+eOBWOtf
# 0wTiamVKkKZyKmxsmlPVxR5jHyT3ve5mvk+RBkQzM28iEAa8lYlYSh6iDYNihelT
# yvvG7FQ9EU5BNiReWSWUaai5mpGvbbMTch6zwttZaQny5XaYDy6e6o8utbbot/kB
# Z33UMMvK2cqubl2V2Uyw+nbQvqiSBrYNEk2PT8fFRR3WmPNTv/XC/zXSXwAmaN/I
# pEfhEVpSFMRdlq+QlduEXGmrYm6zkzjJypUD19m8z6sWX+VzU3ybciNLjZ6LFvu9
# U5q3IYV6BfgVuOT5L3RkoxbE7pBMXGMMCmGWdirtIkEqC88H91y5gxwHA/ShghNb
# MIITVwYKKwYBBAGCNwMDATGCE0cwghNDBgkqhkiG9w0BBwKgghM0MIITMAIBAzEP
# MA0GCWCGSAFlAwQCAgUAMIH6BgsqhkiG9w0BCRABBKCB6gSB5zCB5AIBAQYKKwYB
# BAGyMQIBATAxMA0GCWCGSAFlAwQCAQUABCC8fvN3wmuhxNRIb/v2vbGS/JeV+qrB
# Pmwf9orUYVcogAIVALV9hHBRW/2LDqSa3NVbN1JXKitrGA8yMDIyMDYwMTIyNDQw
# MFoCCEzfk26byRJnoG6kbDBqMQswCQYDVQQGEwJHQjETMBEGA1UECBMKTWFuY2hl
# c3RlcjEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVkMSwwKgYDVQQDDCNTZWN0aWdv
# IFJTQSBUaW1lIFN0YW1waW5nIFNpZ25lciAjM6CCDeowggb2MIIE3qADAgECAhEA
# kDl/mtJKOhPyvZFfCDipQzANBgkqhkiG9w0BAQwFADB9MQswCQYDVQQGEwJHQjEb
# MBkGA1UECBMSR3JlYXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgw
# FgYDVQQKEw9TZWN0aWdvIExpbWl0ZWQxJTAjBgNVBAMTHFNlY3RpZ28gUlNBIFRp
# bWUgU3RhbXBpbmcgQ0EwHhcNMjIwNTExMDAwMDAwWhcNMzMwODEwMjM1OTU5WjBq
# MQswCQYDVQQGEwJHQjETMBEGA1UECBMKTWFuY2hlc3RlcjEYMBYGA1UEChMPU2Vj
# dGlnbyBMaW1pdGVkMSwwKgYDVQQDDCNTZWN0aWdvIFJTQSBUaW1lIFN0YW1waW5n
# IFNpZ25lciAjMzCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAJCycT95
# 4dS5ihfMw5fCkJRy7Vo6bwFDf3NaKJ8kfKA1QAb6lK8KoYO2E+RLFQZeaoogNHF7
# uyWtP1sKpB8vbH0uYVHQjFk3PqZd8R5dgLbYH2DjzRJqiB/G/hjLk0NWesfOA9YA
# ZChWIrFLGdLwlslEHzldnLCW7VpJjX5y5ENrf8mgP2xKrdUAT70KuIPFvZgsB3YB
# cEXew/BCaer/JswDRB8WKOFqdLacRfq2Os6U0R+9jGWq/fzDPOgNnDhm1fx9HptZ
# jJFaQldVUBYNS3Ry7qAqMfwmAjT5ZBtZ/eM61Oi4QSl0AT8N4BN3KxE8+z3N0Ofh
# l1tV9yoDbdXNYtrOnB786nB95n1LaM5aKWHToFwls6UnaKNY/fUta8pfZMdrKAza
# rHhB3pLvD8Xsq98tbxpUUWwzs41ZYOff6Bcio3lBYs/8e/OS2q7gPE8PWsxu3x+8
# Iq+3OBCaNKcL//4dXqTz7hY4Kz+sdpRBnWQd+oD9AOH++DrUw167aU1ymeXxMi1R
# +mGtTeomjm38qUiYPvJGDWmxt270BdtBBcYYwFDk+K3+rGNhR5G8RrVGU2zF9OGG
# J5OEOWx14B0MelmLLsv0ZCxCR/RUWIU35cdpp9Ili5a/xq3gvbE39x/fQnuq6xzp
# 6z1a3fjSkNVJmjodgxpXfxwBws4cfcz7lhXFAgMBAAGjggGCMIIBfjAfBgNVHSME
# GDAWgBQaofhhGSAPw0F3RSiO0TVfBhIEVTAdBgNVHQ4EFgQUJS5oPGuaKyQUqR+i
# 3yY6zxSm8eAwDgYDVR0PAQH/BAQDAgbAMAwGA1UdEwEB/wQCMAAwFgYDVR0lAQH/
# BAwwCgYIKwYBBQUHAwgwSgYDVR0gBEMwQTA1BgwrBgEEAbIxAQIBAwgwJTAjBggr
# BgEFBQcCARYXaHR0cHM6Ly9zZWN0aWdvLmNvbS9DUFMwCAYGZ4EMAQQCMEQGA1Ud
# HwQ9MDswOaA3oDWGM2h0dHA6Ly9jcmwuc2VjdGlnby5jb20vU2VjdGlnb1JTQVRp
# bWVTdGFtcGluZ0NBLmNybDB0BggrBgEFBQcBAQRoMGYwPwYIKwYBBQUHMAKGM2h0
# dHA6Ly9jcnQuc2VjdGlnby5jb20vU2VjdGlnb1JTQVRpbWVTdGFtcGluZ0NBLmNy
# dDAjBggrBgEFBQcwAYYXaHR0cDovL29jc3Auc2VjdGlnby5jb20wDQYJKoZIhvcN
# AQEMBQADggIBAHPa7Whyy8K5QKExu7QDoy0UeyTntFsVfajp/a3Rkg18PTagadnz
# mjDarGnWdFckP34PPNn1w3klbCbojWiTzvF3iTl/qAQF2jTDFOqfCFSr/8R+lmwr
# 05TrtGzgRU0ssvc7O1q1wfvXiXVtmHJy9vcHKPPTstDrGb4VLHjvzUWgAOT4BHa7
# V8WQvndUkHSeC09NxKoTj5evATUry5sReOny+YkEPE7jghJi67REDHVBwg80uIid
# yCLxE2rbGC9ueK3EBbTohAiTB/l9g/5omDTkd+WxzoyUbNsDbSgFR36bLvBk+9uk
# AzEQfBr7PBmA0QtwuVVfR745ZM632iNUMuNGsjLY0imGyRVdgJWvAvu00S6dOHw1
# 4A8c7RtHSJwialWC2fK6CGUD5fEp80iKCQFMpnnyorYamZTrlyjhvn0boXztVoCm
# 9CIzkOSEU/wq+sCnl6jqtY16zuTgS6Ezqwt2oNVpFreOZr9f+h/EqH+noUgUkQ2C
# /L1Nme3J5mw2/ndDmbhpLXxhL+2jsEn+W75pJJH/k/xXaZJL2QU/bYZy06LQwGTS
# OkLBGgP70O2aIbg/r6ayUVTVTMXKHxKNV8Y57Vz/7J8mdq1kZmfoqjDg0q23fbFq
# QSduA4qjdOCKCYJuv+P2t7yeCykYaIGhnD9uFllLFAkJmuauv2AV3Yb1MIIG7DCC
# BNSgAwIBAgIQMA9vrN1mmHR8qUY2p3gtuTANBgkqhkiG9w0BAQwFADCBiDELMAkG
# A1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxFDASBgNVBAcTC0plcnNleSBD
# aXR5MR4wHAYDVQQKExVUaGUgVVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMTJVVT
# RVJUcnVzdCBSU0EgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkwHhcNMTkwNTAyMDAw
# MDAwWhcNMzgwMTE4MjM1OTU5WjB9MQswCQYDVQQGEwJHQjEbMBkGA1UECBMSR3Jl
# YXRlciBNYW5jaGVzdGVyMRAwDgYDVQQHEwdTYWxmb3JkMRgwFgYDVQQKEw9TZWN0
# aWdvIExpbWl0ZWQxJTAjBgNVBAMTHFNlY3RpZ28gUlNBIFRpbWUgU3RhbXBpbmcg
# Q0EwggIiMA0GCSqGSIb3DQEBAQUAA4ICDwAwggIKAoICAQDIGwGv2Sx+iJl9AZg/
# IJC9nIAhVJO5z6A+U++zWsB21hoEpc5Hg7XrxMxJNMvzRWW5+adkFiYJ+9UyUnku
# yWPCE5u2hj8BBZJmbyGr1XEQeYf0RirNxFrJ29ddSU1yVg/cyeNTmDoqHvzOWEnT
# v/M5u7mkI0Ks0BXDf56iXNc48RaycNOjxN+zxXKsLgp3/A2UUrf8H5VzJD0BKLwP
# DU+zkQGObp0ndVXRFzs0IXuXAZSvf4DP0REKV4TJf1bgvUacgr6Unb+0ILBgfrhN
# 9Q0/29DqhYyKVnHRLZRMyIw80xSinL0m/9NTIMdgaZtYClT0Bef9Maz5yIUXx7gp
# GaQpL0bj3duRX58/Nj4OMGcrRrc1r5a+2kxgzKi7nw0U1BjEMJh0giHPYla1IXMS
# Hv2qyghYh3ekFesZVf/QOVQtJu5FGjpvzdeE8NfwKMVPZIMC1Pvi3vG8Aij0bdon
# igbSlofe6GsO8Ft96XZpkyAcSpcsdxkrk5WYnJee647BeFbGRCXfBhKaBi2fA179
# g6JTZ8qx+o2hZMmIklnLqEbAyfKm/31X2xJ2+opBJNQb/HKlFKLUrUMcpEmLQTkU
# Ax4p+hulIq6lw02C0I3aa7fb9xhAV3PwcaP7Sn1FNsH3jYL6uckNU4B9+rY5WDLv
# bxhQiddPnTO9GrWdod6VQXqngwIDAQABo4IBWjCCAVYwHwYDVR0jBBgwFoAUU3m/
# WqorSs9UgOHYm8Cd8rIDZsswHQYDVR0OBBYEFBqh+GEZIA/DQXdFKI7RNV8GEgRV
# MA4GA1UdDwEB/wQEAwIBhjASBgNVHRMBAf8ECDAGAQH/AgEAMBMGA1UdJQQMMAoG
# CCsGAQUFBwMIMBEGA1UdIAQKMAgwBgYEVR0gADBQBgNVHR8ESTBHMEWgQ6BBhj9o
# dHRwOi8vY3JsLnVzZXJ0cnVzdC5jb20vVVNFUlRydXN0UlNBQ2VydGlmaWNhdGlv
# bkF1dGhvcml0eS5jcmwwdgYIKwYBBQUHAQEEajBoMD8GCCsGAQUFBzAChjNodHRw
# Oi8vY3J0LnVzZXJ0cnVzdC5jb20vVVNFUlRydXN0UlNBQWRkVHJ1c3RDQS5jcnQw
# JQYIKwYBBQUHMAGGGWh0dHA6Ly9vY3NwLnVzZXJ0cnVzdC5jb20wDQYJKoZIhvcN
# AQEMBQADggIBAG1UgaUzXRbhtVOBkXXfA3oyCy0lhBGysNsqfSoF9bw7J/RaoLlJ
# WZApbGHLtVDb4n35nwDvQMOt0+LkVvlYQc/xQuUQff+wdB+PxlwJ+TNe6qAcJlhc
# 87QRD9XVw+K81Vh4v0h24URnbY+wQxAPjeT5OGK/EwHFhaNMxcyyUzCVpNb0llYI
# uM1cfwGWvnJSajtCN3wWeDmTk5SbsdyybUFtZ83Jb5A9f0VywRsj1sJVhGbks8Vm
# Bvbz1kteraMrQoohkv6ob1olcGKBc2NeoLvY3NdK0z2vgwY4Eh0khy3k/ALWPncE
# vAQ2ted3y5wujSMYuaPCRx3wXdahc1cFaJqnyTdlHb7qvNhCg0MFpYumCf/RoZSm
# Tqo9CfUFbLfSZFrYKiLCS53xOV5M3kg9mzSWmglfjv33sVKRzj+J9hyhtal1H3G/
# W0NdZT1QgW6r8NDT/LKzH7aZlib0PHmLXGTMze4nmuWgwAxyh8FuTVrTHurwROYy
# bxzrF06Uw3hlIDsPQaof6aFBnf6xuKBlKjTg3qj5PObBMLvAoGMs/FwWAKjQxH/q
# EZ0eBsambTJdtDgJK0kHqv3sMNrxpy/Pt/360KOE2See+wFmd7lWEOEgbsausfm2
# usg1XTN2jvF8IAwqd661ogKGuinutFoAsYyr4/kKyVRd1LlqdJ69SK6YMYIELTCC
# BCkCAQEwgZIwfTELMAkGA1UEBhMCR0IxGzAZBgNVBAgTEkdyZWF0ZXIgTWFuY2hl
# c3RlcjEQMA4GA1UEBxMHU2FsZm9yZDEYMBYGA1UEChMPU2VjdGlnbyBMaW1pdGVk
# MSUwIwYDVQQDExxTZWN0aWdvIFJTQSBUaW1lIFN0YW1waW5nIENBAhEAkDl/mtJK
# OhPyvZFfCDipQzANBglghkgBZQMEAgIFAKCCAWswGgYJKoZIhvcNAQkDMQ0GCyqG
# SIb3DQEJEAEEMBwGCSqGSIb3DQEJBTEPFw0yMjA2MDEyMjQ0MDBaMD8GCSqGSIb3
# DQEJBDEyBDCSF1e/KBVr6BX3d4EjDkw6zItIvIzyXqpZPo71GdJzVuIQfZaIyLNn
# VQUrKuxnuAQwge0GCyqGSIb3DQEJEAIMMYHdMIHaMIHXMBYEFKs0ATqsQJcxnwga
# 8LMY4YP4D3iBMIG8BBQC1luV4oNwwVcAlfqI+SPdk3+tjzCBozCBjqSBizCBiDEL
# MAkGA1UEBhMCVVMxEzARBgNVBAgTCk5ldyBKZXJzZXkxFDASBgNVBAcTC0plcnNl
# eSBDaXR5MR4wHAYDVQQKExVUaGUgVVNFUlRSVVNUIE5ldHdvcmsxLjAsBgNVBAMT
# JVVTRVJUcnVzdCBSU0EgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkCEDAPb6zdZph0
# fKlGNqd4LbkwDQYJKoZIhvcNAQEBBQAEggIASW5ZQX3E3Zn0Iow243AKtTe3RAyb
# wZp2tc6neNAvQYImTpMS7SEncp5cIXbFIXh+FRRABjrtKGIVrmvbW9iRYZeMoHNy
# O8BKjsrBVD3GZp13w8udcsM88u7YBTUYpWDp292uzcTHtv1mrXdx2m6TkQ7LFbIr
# rbjClnJ65XhR0PyAx3pd30SfU0KIbK/zmF0ZgViMdeeBxTy5c4o9TsPUyTvdL9pM
# lwsjSTheuGY2UQ8c3z31DcvMAY6Wf6PFQTF3QFMB97BmhqYSlCrDi/eD1iRWsrRf
# Ozd0DRHRBzHy5dBXxc6BwY13yQzDtEUDcLJjudAmBkdNyP3r8E37DholIDZm+9XI
# kIadZuK/Gm3xSbudDNBV4+pXJ7a08ArPz2cblk49zzY5hcaKpfZpQ9TmflgUn/Tq
# aeDrjKbxB0BjW53cghfqYTmwqb8izK2gKTPwCelzEOGsX+IHU5wDZ9CnjrQ3ZTF2
# u6CT54JinoRCPDs1Q/PaQAWsOKu4GqVN9FKlEA4eDPfPOkKMq+CiTAii9CfrzsTm
# 6rd6HhsRMHT6eJvhDkm0XXt2hJAVjOltJOH0cnNGrPVcxmCg14yarM314PPGNUdJ
# 30MvYEf1/0KWihvzaPGYcP5JUvbFrRQbpKgfq1B9a9k8DjYtPCqLV1+zmmQGhzhH
# XenPVyKS1BrkB48=
# SIG # End signature block
