<?php




class SocketClient
{

    protected $socket = null;
    protected $host;
    protected $port;

    public function __construct($host, $port)
    {
        $this->host = $host;
        $this->port = $port;

    }

    public function connect()
    {
        $context = stream_context_create([
            'socket' => [
                'connect_timeout' => 3, // 连接超时时间
                'timeout' => 3, // 发送和接收超时时间
                'rcvbuf' => 65536,
                'sndbuf' => 65536,
            ],
        ]);
        $this->socket = stream_socket_client("udp://{$this->host}:{$this->port}", $errno, $errstr,3, STREAM_CLIENT_CONNECT, $context);
        if (!$this->socket) {
             error_log("create socket failed:". $errno . "\n" , 3, "/var/www/inc/log.txt");
        }

        if (!$this->socket) {
            throw new Exception("设备连接失败");
        }
    }

    public function request($data)
    {
        if(!$this->socket){
            $this->connect();
        }
        try {
            fwrite($this->socket, $data . "\n");
            // 设置接收缓冲区大小为65536字节（64K）
            $bufferSize = 65536;
            // 用于存储接收到的数据
            $received = stream_socket_recvfrom($this->socket, $bufferSize );
            if ($received === false) {
                $errorCode = socket_last_error();
                $errorMsg = socket_strerror($errorCode);
                error_log("Could not receive data:". $errorMsg. ($errorCode) . "\n" , 3, "/var/www/inc/log.txt");
            }
            // $infoResult = json_decode($received, true);
            // if ($infoResult === null) {
            //     error_log("json decode failed:". strlen($data) . "\n" , 3, "/var/www/inc/log.txt");
            // }else
            // {
            //     error_log("json decode success:". strlen($data) . "\n" , 3, "/var/www/inc/log.txt");
            // }

        }catch (Exception $exception){
            throw new Exception("设备请求失败");
        }

        //error_log("udp done:". $received . "\n", 3, "/var/www/inc/log.txt");
        return $received;
    }
}
