<?php


class DB
{
    /**
     * @var SQLite3
     */
    protected $sqlite = null;

    public function open($filename)
    {
        if (file_exists($filename)) {
            $this->sqlite = new SQLite3($filename);
        } else {
            die('数据库文件不存在');
        }
    }

    public function query($sql)
    {
        $result = $this->sqlite->query($sql);

        $data = [];
        while ($row = $result->fetchArray(SQLITE3_ASSOC)) {
            $data[] = $row;
        }

        return $data;
    }

    public function exec($sql)
    {
        $result = $this->sqlite->exec($sql);
        return $result;
    }

    public function find($sql)
    {
        $result = $this->query($sql);
        if ($result) {
            return $result[0];
        } else {
            return null;
        }
    }

    public function count($sql)
    {
        $result = $this->query($sql);
        return intval(current($result[0]));
    }


    public function paginate($sql, $pageSie = 20)
    {
        $page = intval(input('page')) ?? 1;
        $sql .= ' limit ' . ($page - 1) * $pageSie . ',' . $pageSie;
        return $this->query($sql);
    }

    public function getLastId()
    {
        return $this->sqlite->lastInsertRowID();
    }
}
