<?php


class settings extends controller
{

    public function __construct()
    {
        parent::__construct();
        checkLogin();
    }

    public function index()
    {
        $result = $this->db->query('select * from settings');
        $data = [];
        foreach ($result as $item) {
            $data[$item['name']] = $item['value'];
        }

       $data = array_merge($data, require '../inc/config.php');
        success($data);
    }

    public function levelMaster()
    {
        checkPermission('级联设置');
        $slave_count = intval(input('slave_count'));
        $slave_addresses = (array)input('slave_addresses');
        $addrList = Arr::pluck($slave_addresses, 'addr');
        if (count($addrList) != count(array_unique($addrList))) {
            error('从机地址不能重复');
        }
        if ($this->db->find("select * from settings where name='pdu_type'")) {
            $this->db->exec("update settings set value = 'master' where name = 'pdu_type'");
        } else {
            $this->db->exec("insert into settings (name,value) values('pdu_type','master')");
        }

        if ($this->db->find("select * from settings where name='slave_count'")) {
            $this->db->exec("update settings set value = {$slave_count} where name = 'slave_count'");
        } else {
            $this->db->exec("insert into settings (name,value) values('slave_count',{$slave_count})");
        }


        $slave_addresses_json = json_encode($slave_addresses);
        if ($this->db->find("select * from settings where name='slave_addresses'")) {
            $this->db->exec("update settings set value = '{$slave_addresses_json}' where name = 'slave_addresses'");
        } else {
            $this->db->exec("insert into settings (name,value) values('slave_addresses','{$slave_addresses_json}'");
        }

        // $this->device->setMaster(0, array_map(function ($item) {
        //     return $item['addr'];
        // }, $slave_addresses));

        $this->writeLog("设置主机类型为【master】");

        success([]);
    }

    public function levelSlave()
    {
        checkPermission('级联设置');
        $slave_address = intval(input('slave_address'));
        if (is_null($slave_address)) {
            error('请输入从机地址');
        }
        if (!($slave_address > 0 && $slave_address <= 127)) {
            error('从机地址不正确');
        }

        if ($this->db->find("select * from settings where name='pdu_type'")) {
            $this->db->exec("update settings set value = 'slave' where name = 'pdu_type'");
        } else {
            $this->db->exec("insert into settings (name,value) values('pdu_type','master')");
        }
        if ($this->db->find("select * from settings where name='slave_address'")) {
            $this->db->exec("update settings set value = {$slave_address} where name = 'slave_address'");
        } else {
            $this->db->exec("insert into settings (name,value) values('slave_count',{$slave_address})");
        }

        $this->writeLog('设置主机类型为【slave】');
        success([]);

    }

    // de-DE 德语-德国
    public function language()
    {
        $language = input('language');
        if ($language == 'zh-CN') {
            $language = 'CHS';
        } else if ($language == 'de-DE'){
            $language = 'de-DE';
        }
        else {
            $language = 'ENG';
        }

        if ($this->db->find("select * from settings where name='language'")) {
            $this->db->exec("update settings set value = '{$language}' where name = 'language'");
        } else {
            $this->db->exec("insert into settings (name,value) values('language','{$language}')");
        }
        success([]);

    }

    public function network()
    {
        checkPermission('网络设置');
        $ip = input('ip');
        $mask = input('mask');
        $gateway = input('gateway');
        $dns = input('dns');
        $second_dns = input('second_dns');
        $dhcp = intval(input('dhcp'));
        $netbios_name = input('netbios_name');
        $http_port = intval(input('http_port'));
        $https_port = intval(input('https_port'));
        $enable_redirect = intval(input('enable_redirect'));

        $ip_2 = input('ip_2');
        $mask_2 = input('mask_2');
        $gateway_2 = input('gateway_2');
        $dns_2 = input('dns_2');
        $second_dns_2 = input('second_dns_2');
        $dhcp_2 = intval(input('dhcp_2'));
        $netbios_name_2 = input('netbios_name_2');
        $http_port_2 = intval(input('http_port_2'));
        $https_port_2 = intval(input('https_port_2'));
        $enable_redirect_2 = intval(input('$enable_redirect_2'));
        if (!$ip || !$mask || !$gateway || !$dns) {
            error('数据输入错误');
        }
        if (!is_ip($ip) || !is_ip($mask) || !is_ip($gateway) || !is_ip($dns) || ($second_dns && !is_ip($second_dns))) {
            error('数据输入错误');
        }

        foreach (['ip', 'mask', 'gateway', 'dns', 'second_dns', 'dhcp', 'netbios_name', 'http_port', 'https_port','enable_redirect', 'ip_2', 'mask_2', 'gateway_2', 'dns_2', 'second_dns_2', 'dhcp_2', 'netbios_name_2', 'http_port_2','https_port_2','enable_redirect_2'] as $item) {
            if ($this->db->find("select * from settings where name = '{$item}'")) {
                $this->db->exec("update settings set value = '{$$item}' where name = '{$item}'");
            } else {
                $this->db->exec("insert into settings (name,value) values('{$item}','{$$item}')");
            }
        }

        $this->writeLog("修改了网络设置");
        success("[]");

    }

    public function pduNames()
    {
        checkPermission('端口名称设置');
        $addr = intval(input('addr'));
        $name = input('name');
        $portsName = (array)input('portsName');
        $this->device->setPortName($addr, $name, $portsName);
        $_SESSION['port_name'][$addr] = [];
        $_SESSION['pdu_name'] = null;
        $this->writeLog("修改了PDU端口名称【addr:{$addr}】");

        success([]);

    }

    public function getDelay()
    {
        checkPermission('端口延迟设置');
        $addr = intval(input('addr'));
        $result = $this->device->getPortDelay($addr);
        success($result);
    }

    public function getDelayPoweroff()
    {
        checkPermission('端口延迟设置');
        $addr = intval(input('addr'));
        $result = $this->device->getPortDelayPoweroff($addr);
        success($result);
    }

    public function updateDelay()
    {
        checkPermission('端口延迟设置');
        $addr = intval(input('addr'));
        $list = (array)input('list');
        $this->device->setPortDelay($addr, $list);
        $this->writeLog("更新了端口延迟【addr:{$addr}】");
        success([]);
    }

    public function updateDelayPoweroff()
    {
        checkPermission('端口延迟设置');
        $addr = intval(input('addr'));
        $list = (array)input('list');
        $this->device->setPortDelayPoweroff($addr, $list);
        $this->writeLog("更新了端口断电延迟【addr:{$addr}】");
        success([]);
    }

    public function getPing()
    {
        checkPermission('PING设置');
        $addr = intval(input('addr'));
        $ports = (array)input('ports');
        $result = $this->device->getPing($addr,$ports);
        success($result);
    }

    public function updatePing()
    {

        checkPermission('PING设置');
        $addr = intval(input('addr'));
        $list = (array)input('list');
        $list = array_filter($list,function ($item){
            return $item['ip'] !== null;
        });
        $data =  array_map(function ($item){
            return [
                'port'=>(int)$item['port'],
                'ip'=>$item['ip'],
                'interval'=>(int)$item['interval'],
                'timeout'=>(int)$item['timeout'],
                'action'=>(int)$item['action'],
                'enabled'=>(int)$item['enabled']
            ];
        },$list);



        $this->device->setPing($addr, $data);
        $this->writeLog("更新了PING设置【addr:{$addr}】");
        success([]);
    }

    public function testPing()
    {
        $addr = input('addr');
        $port = input('port');
        $ip = input('ip');
        $this->device->testPing($addr, $port, $ip);
        $i = 0;
        while (true){
            $status = $this->device->testPingStatus($addr,$port);
            if($status['result'] === 0){
                success([]);
            }else if ($i > 5){
                error('Ping测试失败');
            }
            $i++;
            usleep(500000);
        }
    }

    public function snmp()
    {
        checkPermission('SNMP设置');
        $snmp_enable = intval(input('snmp_enable'));
        $snmp_group = input('snmp_group');
        $snmp_permission = intval(input('snmp_permission'));
        $snmp_trap = intval(input('snmp_trap'));
        $snmp_address = input('snmp_address');
        $snmp_v3_user = input('snmp_v3_user');
        $snmp_v3_auth_pwd = input('snmp_v3_auth_pwd');
        $snmp_v3_priv_pwd = input('snmp_v3_priv_pwd');

        if ($snmp_enable) {
            if (!$snmp_group || !$snmp_address) {
                error('数据输入错误');
            }
            if (!is_ip($snmp_address)) {
                error('接收地址必须为IP');
            }
        }

        if ($snmp_enable) {
            $data = ['snmp_enable', 'snmp_group', 'snmp_permission', 'snmp_trap', 'snmp_address','snmp_v3_user','snmp_v3_auth_pwd','snmp_v3_priv_pwd'];
        } else {
            $data = ['snmp_enable'];
        }

        foreach ($data as $item) {
            if ($this->db->find("select * from settings where name = '{$item}'")) {
                $this->db->exec("update settings set value = '{$$item}' where name = '{$item}'");
            } else {
                $this->db->exec("insert into settings (name,value) values('{$item}','{$$item}')");
            }
        }

        $this->writeLog("修改了SNMP设置");
        success("[]");
    }

    public function datetime()
    {
        $ntp = $this->device->getNtp(0);
        success(['time' => time(), 'ntp' => $ntp]);
    }

    public function updateDatetime()
    {
        checkPermission('更新系统时间');
        $datetime = local2utc(input('datetime'));
        if (!$datetime) {
            error('时间输入不正确');
        }
        $this->writeLog('修改了系统时间');
        try {
            $this->device->setDateTime(strtotime($datetime));
        } catch (Exception $e) {
            exit($e->getMessage());
        }
        success([]);
    }

    public function updateNtp()
    {
        checkPermission('更新系统时间');
        $this->writeLog('修改了NTP服务器设置');
        try {
            $this->device->setNtp(0, input('master_ntp_server'), input('slave_ntp_server'));
        } catch (Exception $e) {
            exit($e->getMessage());
        }
        success([]);
    }

    public function reset()
    {
        checkPermission('电表清零');
        $addr = intval(input('addr'));

        $this->device->reset($addr);
        $this->writeLog("电表清零【addr:{$addr}】");
        success([]);
    }


    public function restore()
    {
        $db = 'pdu_default.db';
        $source = '/var/www/database/pdu_default.db';
        $dest = '/var/www/public/uploads/';
        checkPermission('恢复出厂设置');
        $addr = intval(input('addr'));
        //恢复出厂设置
        if (file_exists($source)) {
            if (!is_dir($dest)) {
                mkdir($dest, 0777, true);
            }
            copy($source, $dest . $db);
        } else {
            error('出厂配置文件读取失败');
        }
        //逻辑待完善
        $this->device->restart($addr);
        $this->writeLog("恢复出厂设置【addr:{$addr}】");
        success([]);
    }


    public function upload()
    {
        checkPermission('系统升级');
        $path = './uploads/';
        $file = $_FILES['file'];
        if (!$file) {
            error('请上传系统文件');
        }

        if (strtolower(pathinfo($file['name'], PATHINFO_EXTENSION)) != 'zip') {
            error('只能上传ZIP文件');
        }

        if (!file_exists($path)) {
            mkdir($path, 0755, true);
        }
        //$path = $path . time() . '.zip';
        $path = $path . 'upgrade' . '.zip';
        move_uploaded_file($file['tmp_name'], $path);
        success(['file' => base64_encode($path)]);
    }

    public function upgrade()
    {
        checkPermission('系统升级');

        global $upgrade_root;

        /*
                $file = base64_decode(input('file'));
                if (!file_exists($file)) {
                    error('文件不存在');
                }
                if (!$upgrade_root) {
                    error('解压路径不存在');
                }
                try {
                    $zip = new ZipArchive();
                    $zip->open($file);
                    $zip->extractTo($upgrade_root);
                    $zip->close();
                } catch (\Exception $exception) {
                    error('升级失败');
                }

                $this->writeLog("系统升级");
                success($upgrade_root);
        */
        $this->device->restart(0);
        success([]);
    }


}
