<?php


class devices extends controller
{
    public function __construct()
    {

        parent::__construct();
        checkLogin();

    }

    public function index()
    {
        $result = $this->device->getDeviceList();
        $settings = $this->db->query('select * from settings');
        $uid = null;
        foreach ($settings as $setting) {
            if ($setting['name'] === 'hard_id') {
                $uid = $setting['value'];
            }
        }

        $map = [
            1, 4, 8, 12, 16, 20, 24, 2, 3
        ];
        $port_id = 0;
        if ($uid) {
            $port_id = substr($uid, 2, 1);
        }
        $port_num = $map[intval($port_id)];
        foreach ($result as $key => $value) {
            if ($value['addr'] === 0) {
                $result[$key]['port_num'] = $port_num;
            } else {
                $result[$key]['port_num'] = null;
            }
        }
        successNoNumber($result);
    }

    public function operate()
    {
        checkPermission('操作端口');
        $addr = input('addr');
        $ports = (array)input('ports');
        $action = input('action');

        switch (intval($action)) {
            case 0:
                $actionText = '关闭';
                break;
            case 1:
                $actionText = '打开';
                break;
            case 2:
                $actionText = '重启';
                break;
            default:
                $actionText = '未知操作';
                error('未知操作');
        }

        $this->device->operatePort($addr, $ports, $action);
        foreach ($ports as $port) {
            $logArr = array(
                'action' => $actionText,
                'addr' => $addr,
                'port' => intval($port)
            );
            $this->writeLog(json_encode($logArr, JSON_UNESCAPED_UNICODE));
        }
        success([]);
    }
}





