<?php

class account extends controller
{
    public function __construct()
    {
        parent::__construct();
        $isPermissions = false;
        foreach ($_REQUEST as $key => $value) {
            if ($key == 'router' && $value == 'account/permissions')
            {
                $isPermissions = true;
                break;
            }
        }
        if ($isPermissions == false)
        {
            checkLogin();
            checkPermission('账户管理');
        }
        
    }

    public function index()
    {
        $role = input('role');
        $username = input('username');
        $language = input('language');

        $where = '1=1';
        if ($role) {
            $where .= " and role = {$role}";
        }
        if ($username) {
            $where .= " and username  like '%{$username}%'";
        }

        $sql = "select * from users where {$where} order by id desc";
        $result = $this->db->paginate($sql);
        foreach ($result as &$item) {
            unset($item['password']);
            if ($item['remark'] === '系统超级管理员' && $language === 'de-DE')
            {
                $item['remark'] = 'Administrator';
            }
        }
        $count = $this->db->count("select count(*) from users where {$where}");

        success($result, getMeta($count));
    }

    public function save()
    {
        $username = input('username');
        $password = input('password');
        $role = input('role');
        $status = intval(input('status'));
        $remark = input('remark');

        if (!$username) {
            error('请输入用户名');
        }
        if (!$password) {
            error('请输入密码');
        }
        if (!$role) {
            error('请选择用户组');
        }
        if (mb_strlen($password) < 6) {
            error('密码长度过短');
        }
        $hasUser = $this->db->count("select count(*) from users where username = '{$username}'");
        if ($hasUser) {
            error('用户名已存在');
        }

        $password = password_hash($password, PASSWORD_DEFAULT);
        $sql = "insert into users (username,password,role,status,remark,created_at,updated_at) values('{$username}','{$password}','{$role}',{$status},'{$remark}','{$this->datetime}','{$this->datetime}')";

        $this->db->exec($sql);

        $this->writeLog("创建了系统账户【{$username}】");

        success([]);
    }


    public function update()
    {
        $id = intval(input('id'));
        if (!$id) {
            error('参数错误');
        }
        $password = input('password');
        $role = input('role');
        $status = intval(input('status'));
        $remark = input('remark');


        if (!$role) {
            error('请选择用户组');
        }
        if ($password && mb_strlen($password) < 6) {
            error('密码长度过短');
        }


        if ($password) {
            $password = password_hash($password, PASSWORD_DEFAULT);
        }
        $user = $this->db->find("select * from users where id = {$id}");
        if (!$user) {
            error('用户不存在');
        }
        if ($user['role'] == 'admin') {
            if (!$status) {
                error('超级管理员账户不能禁用');
            }
            if ($role !== 'admin') {
                error('超级管理员账户不能修改用户组');
            }
        }

        $sql = "update users set role = '{$role}',status = {$status},remark = '{$remark}',updated_at = '{$this->datetime}'";
        if ($password) {
            $sql .= ",password = '{$password}'";
        }
        $sql .= "where id = {$id}";

        $this->db->exec($sql);
        $this->writeLog("修改了系统账户【{$user['username']}】");
        success([]);

    }

    public function show()
    {
        $id = intval(input('id'));
        if (!$id) {
            error('参数错误');
        }

        $user = $this->db->find("select * from users where id={$id}");

        success(Arr::except($user, 'password'));
    }

    public function delete()
    {
        $id = intval(input('id'));
        if (!$id) {
            error('参数错误');
        }
        $user = $this->db->find("select * from users where id={$id}");
        if (!$user) {
            error('用户不存在');
        }

        $this->db->exec("delete from users where id = {$id}");
        $this->writeLog("删除了系统账户【{$user['username']}】");
        success([]);
    }


    public function permissions()
    {
       


        $permissions = require_once '../inc/permission.php';
        $result = $this->db->query("select * from permissions");

        $data = [];

        foreach ($result as $item) {
            $data[$item['role']][] = $item['permission'];
        }

        $return = [];
        foreach (['operator', 'visitor'] as $role) {
            foreach ($permissions as $per) {
                //fix 查看权限的时候，隐藏部分权限选项
                if ($role === 'visitor') {
                    if (!in_array($per, ['查看系统日志', '查看用户操作日志', '统计'])) {
                        continue;
                    }
                }
                if ($GLOBALS['Flag']['isExternPort4'] && in_array($per, ['Ping设置', '传感器设置', '温湿度告警设置','输出断电设置','输出告警设置']))
                {
                    continue;
                }
                if (isset($data[$role]) && in_array($per, $data[$role])) {
                    $return[$role][$per] = 1;
                } else {
                    $return[$role][$per] = 0;
                }
            }
        }

        success($return);
    }

    public function savePermissions()
    {
        $role = input('role');
        $permissions = (array)input('permissions');
        if (!$role) {
            error('参数错误');
        }
        $this->db->exec("delete from permissions where role = '{$role}'");
        $sql = ";";
        foreach ($permissions as $per) {
            $sql .= "insert into permissions (role,permission,created_at,updated_at) values('{$role}','{$per}','{$this->datetime}','{$this->datetime}');\n";
        }

        $this->db->exec($sql);

        $this->writeLog("修改了权限配置【{$role}】");
        success([]);

    }

    public function blacklist()
    {
        $total = $this->db->count("select count(*) from blacklist");
        $result = $this->db->paginate("select * from blacklist");
        success($result, getMeta($total));
    }

    public function saveBlackList()
    {
        $ip = input('ip');
        $remark = input('remark');
        if($this->db->count("select count(*) from blacklist where ip = '{$ip}'")){
            error('IP已存在');
        }
        $this->db->exec("insert into blacklist (ip,remark) values ('{$ip}','{$remark}')");
        success([]);
    }

    public function deleteBlackList()
    {
        $id = input('id');
        $this->db->exec("delete from blacklist where id = {$id}");
        success([]);
    }
}
